#!/usr/bin/env python3
# -*- coding: utf-8 -*-
'''
 * Carto_photos  - carto_photo.py
 * Copyright (C) [2024] [BOTREL]
 *
 * Ce programme est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier selon les termes de la licence GNU General Public License
 * telle que publiée par la Free Software Foundation, soit la version 3
 * de la licence, soit (à votre choix) toute version ultérieure.
 *
 * Ce programme est distribué dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de
 * QUALITÉ MARCHANDE ou d'ADÉQUATION À UN USAGE PARTICULIER. Consultez la
 * GNU General Public License pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la GNU General Public License
 * avec ce programme. Si ce n'est pas le cas, consultez <https://www.gnu.org/licenses/>.
 '''

import sys
import os
import time
import geopandas as gpd
import folium
from fastkml import kml
from shapely.geometry import Point, LineString
from selenium import webdriver
from selenium.webdriver.firefox.service import Service
import sys
sys.path.append('dotenv')
from dotenv import load_dotenv
# from webdriver_manager.firefox import GeckoDriverManager
sys.path.append('webdriver_manager')
from webdriver_manager.firefox import GeckoDriverManager
from selenium.webdriver.firefox.options import Options
import xml.etree.ElementTree as ET
from geopy.distance import geodesic
from PIL import Image, ImageDraw, ImageFont
import math
import warnings
import random
import shutil
import piexif
from decimal import Decimal
import hashlib
import re
import tkinter as tk
from tkinter import simpledialog, messagebox
import glob
from pathlib import Path
import subprocess
import distro

# Définir le répertoire de base (où se trouve le script)
base_dir = os.path.dirname(os.path.abspath(__file__))

# Liste des fichiers sans géolocalisation
files_without_geolocation = []

# Fonction pour vérifier la présence de latitude et de longitude dans les métadonnées EXIF
def has_geolocation(file_path):
    exif_dict = piexif.load(file_path)
    gps_info = exif_dict.get('GPS')

    if gps_info is None:
        return False

    # Vérifier la présence des clés GPSLatitude (2) et GPSLongitude (4)
    latitude = gps_info.get(piexif.GPSIFD.GPSLatitude)
    longitude = gps_info.get(piexif.GPSIFD.GPSLongitude)

    print(f"File: {file_path} | Latitude: {latitude}, Longitude: {longitude}")  # Debug

    return latitude is not None and longitude is not None

is_puppy_linux = "puppy" in distro.name().lower()

if not is_puppy_linux:
    import pillow_heif

    # Charger le plugin HEIF/HEIC dans PIL
    pillow_heif.register_heif_opener()

    def heic_to_jpg_with_metadata(input_path, output_path):
        # Ouvrir l'image HEIC/HEIF
        img = Image.open(input_path)

        # Extraire les métadonnées EXIF
        exif_data = img.info.get('exif')

        # Convertir l'image en JPG tout en conservant les métadonnées
        img = img.convert("RGB")
        img.save(output_path, "jpeg", exif=exif_data)

    def batch_convert():
        converted_files = []
        for filename in os.listdir(base_dir):
            if filename.lower().endswith(".heic") or filename.lower().endswith(".heif"):
                input_path = os.path.join(base_dir, filename)
                output_path = os.path.join(base_dir, filename.rsplit(".", 1)[0] + ".jpg")
                heic_to_jpg_with_metadata(input_path, output_path)
                print(f"Converted {filename} to JPG")
                converted_files.append(output_path)
        return converted_files

    # Conversion des images HEIC en JPG
    newly_converted_files = batch_convert()

else:
    print("Les fonctions liées à HEIC/HEIF ne sont pas nécessaires sur Puppy Linux, elles sont donc ignorées.")
    
    from wand.image import Image as WANDImage

    def heic_to_jpg_with_metadata(input_path, output_path):
        # Ouvrir l'image HEIC/HEIF
        with WANDImage(filename=input_path) as img:
            # Convertir l'image en JPG
            img.format = 'jpeg'
            img.save(filename=output_path)
            print(f"Converted {input_path} to {output_path}")

    def batch_convert(base_dir):
        converted_files = []
        for filename in os.listdir(base_dir):
            if filename.lower().endswith(".heic") or filename.lower().endswith(".heif"):
                input_path = os.path.join(base_dir, filename)
                output_path = os.path.join(base_dir, filename.rsplit(".", 1)[0] + ".jpg")
                heic_to_jpg_with_metadata(input_path, output_path)
                converted_files.append(output_path)
        return converted_files

    # Conversion des images HEIC en JPG
    newly_converted_files = batch_convert(base_dir)


# Lister tous les fichiers .jpg dans le répertoire source après conversion
jpg_files = [f for f in os.listdir(base_dir) if f.endswith('.jpg')]

# Vérifier s'il y a des fichiers jpg
if not jpg_files:
    print("Aucun fichier .jpg trouvé dans le répertoire. Le script va s'arrêter.")
    input("Appuyez sur Entrée pour fermer le script...")
    sys.exit()  # Arrêter l'exécution du script si aucun fichier jpg n'est trouvé

# Parcourir tous les fichiers jpg et vérifier la présence de géolocalisation
for jpg_file in jpg_files:
    jpg_path = os.path.join(base_dir, jpg_file)

    if not has_geolocation(jpg_path):
        files_without_geolocation.append(jpg_file)

# Afficher les résultats
if files_without_geolocation:
    print("Les fichiers suivants n'ont pas de données de géolocalisation (latitude/longitude) :")
    for file in files_without_geolocation:
        print(file)
    input("Appuyez sur Entrée pour quitter le script...")
    sys.exit()  # Quitter le script après l'affichage
else:
    print("Tous les fichiers jpg contiennent des données de géolocalisation (latitude/longitude).")
# Définir le répertoire de base (où se trouve le script)
base_dir = os.path.dirname(os.path.abspath(__file__))

# Définir le répertoire source (même que le répertoire du script)
source_dir = base_dir

# Définir le répertoire de destination (sous-répertoire 'nombres')
dest_dir = os.path.join(base_dir, 'nombres')

# Créer le répertoire de destination s'il n'existe pas
if not os.path.exists(dest_dir):
    os.makedirs(dest_dir)

# Lister tous les fichiers .jpg dans le répertoire source
jpg_files = [f for f in os.listdir(source_dir) if f.endswith('.jpg')]

# Compter le nombre de fichiers .jpg
num_files = len(jpg_files)

# Générer une liste de nombres aléatoires uniques
random_numbers = random.sample(range(1, num_files + 1), num_files)

# Copier et renommer les fichiers
for i, filename in enumerate(jpg_files):
    src_path = os.path.join(source_dir, filename)
    # Préfixer avec un zéro si le nombre est inférieur à 10
    new_filename = f"{random_numbers[i]:02}.jpg"
    dest_path = os.path.join(dest_dir, new_filename)
    shutil.copy(src_path, dest_path)

 # print(f"{num_files} fichiers jpg ont été copiés et renommés.")


# Définir le répertoire de base (où se trouve le script)
base_dir = os.path.dirname(os.path.abspath(__file__))

# Définir le répertoire source (même que le répertoire du script)
source_dir = base_dir

# Définir le répertoire de destination (sous-répertoire 'nombres')
dest_dir = os.path.join(base_dir, 'nombres')

# Créer le répertoire de destination s'il n'existe pas
if not os.path.exists(dest_dir):
    os.makedirs(dest_dir)

# Lister tous les fichiers .jpg dans le répertoire source
jpg_files = [f for f in os.listdir(source_dir) if f.endswith('.jpg')]

# Compter le nombre de fichiers .jpg
num_files = len(jpg_files)

# Générer une liste de nombres aléatoires uniques
random_numbers = random.sample(range(1, num_files + 1), num_files)

# Copier et renommer les fichiers
for i, filename in enumerate(jpg_files):
    src_path = os.path.join(source_dir, filename)
    # Préfixer avec un zéro si le nombre est inférieur à 10
    new_filename = f"{random_numbers[i]:02}.jpg"
    dest_path = os.path.join(dest_dir, new_filename)
    shutil.copy(src_path, dest_path)
    


#print(f"{num_files} fichiers jpg ont été copiés et renommés.")



# Fonction pour intégrer une image PNG dans une image JPG
def integrate_png_with_jpg(jpg_file, png_file, output_file):
    if not os.path.isfile(jpg_file):
        raise FileNotFoundError(f"Le fichier JPG spécifié n'existe pas: {jpg_file}")
    if not os.path.isfile(png_file):
        raise FileNotFoundError(f"Le fichier PNG spécifié n'existe pas: {png_file}")
    
    jpg_img = Image.open(jpg_file)
    png_img = Image.open(png_file).convert("RGBA")
    
    jpg_width, jpg_height = jpg_img.size
    png_width, png_height = png_img.size

    left_margin = 20
    bottom_margin = 20

    position = (left_margin, jpg_height - png_height - bottom_margin)
    alpha = png_img.split()[3]

    jpg_img.paste(png_img, position, alpha)
    jpg_img.save(output_file)

    # print(f"Image combinée sauvegardée sous {output_file}")

# Répertoire contenant les images
#directory = "/home/administrateur/Bureau/travail2/nombres"
#output_directory = "/home/administrateur/Bureau/travail2/output"



# Répertoire contenant le script
script_directory = os.path.dirname(os.path.abspath(__file__))

# Répertoire contenant les images
directory = os.path.join(script_directory, "nombres")
# Répertoire de sortie
output_directory = os.path.join(script_directory, "output")

# Créer le répertoire de sortie s'il n'existe pas
os.makedirs(output_directory, exist_ok=True)

# Liste pour stocker les chemins des images combinées
combined_images = []

# Intégration des PNG dans les JPG
for filename in sorted(os.listdir(directory)):
    if filename.lower().endswith(".jpg") or filename.lower().endswith(".jpeg"):
        base_name = os.path.splitext(filename)[0]
        jpg_file = os.path.join(directory, filename)
        png_file = os.path.join(directory, f"{base_name}.png")
        output_file = os.path.join(output_directory, f"combined_{base_name}.jpg")

        if os.path.isfile(png_file):
            integrate_png_with_jpg(jpg_file, png_file, output_file)
            combined_images.append(output_file)

# Fonction pour créer des pages de vignettes
def create_thumbnail_pages(images, thumb_width=800, thumb_height=600, images_per_page=9, border_size=10):
    num_images = len(images)
    if num_images == 0:
        print("Aucune image combinée trouvée.")
        return

    grid_cols = 3
    grid_rows = images_per_page // grid_cols

    page_width = grid_cols * (thumb_width + 2 * border_size)
    page_height = grid_rows * (thumb_height + 2 * border_size)

    num_pages = (num_images + images_per_page - 1) // images_per_page

    for page in range(num_pages):
        thumbnail_page = Image.new('RGB', (page_width, page_height), (255, 255, 255))
        for index in range(images_per_page):
            img_index = page * images_per_page + index
            if img_index >= num_images:
                break

            img = Image.open(images[img_index])
            img.thumbnail((thumb_width, thumb_height), Image.Resampling.LANCZOS)

            bordered_img = Image.new('RGB', (thumb_width + 2 * border_size, thumb_height + 2 * border_size), (255, 255, 255))
            bordered_img.paste(img, (border_size, border_size))

            x = (index % grid_cols) * (thumb_width + 2 * border_size)
            y = (index // grid_cols) * (thumb_height + 2 * border_size)
            thumbnail_page.paste(bordered_img, (x, y))

        output_file = os.path.join(output_directory, f"photos_{page + 1}.jpg")
        thumbnail_page.save(output_file)
        # print(f"Page de vignettes {page + 1} sauvegardée sous {output_file}")

# Déterminer le nombre d'images par page en fonction du nombre total d'images
create_thumbnail_pages(combined_images, images_per_page=9, border_size=10)

# Définir le répertoire de base (où se trouve le script)
base_dir = os.path.dirname(os.path.abspath(__file__))

# Définir le répertoire source (même que le répertoire du script)
source_dir = base_dir

# Définir le répertoire de destination (sous-répertoire 'lettres')
dest_dir = os.path.join(base_dir, 'lettres')

# Créer le répertoire de destination s'il n'existe pas
if not os.path.exists(dest_dir):
    os.makedirs(dest_dir)

# Lister tous les fichiers .jpg dans le répertoire source
jpg_files = [f for f in os.listdir(source_dir) if f.endswith('.jpg')]

# Trier les fichiers par taille de fichier (du plus petit au plus grand)
jpg_files.sort(key=lambda x: os.path.getsize(os.path.join(source_dir, x)))

# Vérifier si le nombre de fichiers dépasse le nombre de lettres disponibles
if len(jpg_files) > 26:
    print("Erreur : Il y a plus de 26 fichiers. Impossible d'assigner une lettre unique à chaque fichier.")
else:
    # Copier et renommer les fichiers
    for i, filename in enumerate(jpg_files):
        src_path = os.path.join(source_dir, filename)
        new_filename = f"{chr(65 + i)}.jpg"  # chr(65) est 'A', chr(66) est 'B', etc.
        dest_path = os.path.join(dest_dir, new_filename)
        shutil.copy(src_path, dest_path)
    
    # print(f"{len(jpg_files)} fichiers jpg ont été copiés et renommés dans le répertoire 'lettres'.")









def fraction_to_decimal(fraction_tuple):
    """Convert a fraction tuple to a decimal number."""
    if not fraction_tuple:
        return Decimal('0')
    num, denom = fraction_tuple
    return Decimal(num) / Decimal(denom)

def dms_to_decimal(degrees, minutes, seconds):
    """Convert degrees, minutes, and seconds to decimal."""
    return degrees + (minutes / 60) + (seconds / 3600)

# Create or clear output files
with open('lat_long.csv', 'w') as f, open('texte_gps.txt', 'w') as g, open('texte_kml.txt', 'w') as k:
    pass

# Iterate over all JPG files in the 'lettres' directory
for file in os.listdir('lettres'):
    if file.endswith('.jpg'):
        file_path = os.path.join('lettres', file)
        
        # Extract GPS information using piexif
        exif_dict = piexif.load(file_path)
        gps_info = exif_dict.get('GPS')

        # Check if GPS information exists
        if gps_info is None:
            print(f"No GPS info found for file: {file}")
            continue

        # Extract and convert GPS coordinates
        lat = gps_info.get(piexif.GPSIFD.GPSLatitude)
        lon = gps_info.get(piexif.GPSIFD.GPSLongitude)
        lat_ref = gps_info.get(piexif.GPSIFD.GPSLatitudeRef)
        lon_ref = gps_info.get(piexif.GPSIFD.GPSLongitudeRef)

        if lat and lon and lat_ref and lon_ref:
            lat_deg = dms_to_decimal(fraction_to_decimal(lat[0]), fraction_to_decimal(lat[1]), fraction_to_decimal(lat[2]))
            lon_deg = dms_to_decimal(fraction_to_decimal(lon[0]), fraction_to_decimal(lon[1]), fraction_to_decimal(lon[2]))

            lat_ref = lat_ref.decode()
            lon_ref = lon_ref.decode()

            if lat_ref == 'S':
                lat_deg = -lat_deg
            if lon_ref == 'W':
                lon_deg = -lon_deg

            # Format the output
            latitude = f"{lat_deg:.6f}"
            longitude = f"{lon_deg:.6f}"
            
            # Get the filename without extension
            nom_fic_sans_ext, _ = os.path.splitext(file)

            # Ensure we have a valid filename substring
            nom_fic = file[8:]
            if not nom_fic:
                nom_fic = "N/A"  # Use a default value if necessary

            # Write to CSV
            size = os.path.getsize(file_path)
            with open('lat_long.csv', 'a') as f:
                f.write(f"{nom_fic_sans_ext},{size},{latitude},{longitude}\n")

            # Write to GPX and KML files
            with open('texte_gps.txt', 'a') as g:
                g.write(f"<wpt lat=\"{latitude}\" lon=\"{longitude}\"><name>{nom_fic_sans_ext}</name><desc>type=information</desc></wpt>\n")

            with open('texte_kml.txt', 'a') as k:
                k.write(f"<Placemark><name>{nom_fic_sans_ext}</name><Point><coordinates>{longitude},{latitude}</coordinates></Point></Placemark>\n")
        else:
            print(f"Incomplete GPS data for file: {file}")

# Remove newlines and wrap with XML tags for GPX and KML files
def wrap_with_xml_tags(input_file, output_file, before_tag, after_tag):
    with open(input_file, 'r') as infile, open(output_file, 'w') as outfile:
        content = infile.read().replace('\n', '')
        outfile.write(f"{before_tag}{content}{after_tag}")

wrap_with_xml_tags('texte_gps.txt', 'gps2.gpx', "<gpx xmlns=\"http://www.topografix.com/GPX/1/1\">", "</gpx>")
wrap_with_xml_tags('texte_kml.txt', 'kml2.kml', "<kml xmlns=\"http://www.opengis.net/kml/2.2\"><Document>", "</Document></kml>")

# Clean up temporary files
os.remove('texte_gps.txt')
os.remove('texte_kml.txt')


def extract_coordinates_from_gpx(file_path, waypoint_name):
    """
    Extrait les coordonnées (latitude, longitude) d'un waypoint spécifique dans un fichier GPX.

    Args:
        file_path (str): Chemin vers le fichier GPX.
        waypoint_name (str): Nom du waypoint dont les coordonnées doivent être extraites.

    Returns:
        tuple: (latitude, longitude) du waypoint, ou None si le waypoint n'est pas trouvé.
    """
    try:
        tree = ET.parse(file_path)
        root = tree.getroot()

        # Namespace par défaut pour GPX
        namespace = {'gpx': 'http://www.topografix.com/GPX/1/1'}

        for wpt in root.findall('gpx:wpt', namespace):
            name = wpt.find('gpx:name', namespace).text
            if name == waypoint_name:
                lat = float(wpt.get('lat'))
                lon = float(wpt.get('lon'))
                return lat, lon

        return None
    except Exception as e:
        print(f"Erreur lors de l'extraction des coordonnées : {e}")
        return None

def calculate_distance_between_waypoints(gpx_file, waypoint_a, waypoint_b):
    """
    Calcule la distance entre deux waypoints nommés dans un fichier GPX.

    Args:
        gpx_file (str): Chemin vers le fichier GPX.
        waypoint_a (str): Nom du premier waypoint.
        waypoint_b (str): Nom du second waypoint.

    Returns:
        float: Distance en mètres entre les deux waypoints, arrondie au mètre près.
    """
    coord_a = extract_coordinates_from_gpx(gpx_file, waypoint_a)
    coord_b = extract_coordinates_from_gpx(gpx_file, waypoint_b)

    if coord_a and coord_b:
        # Calculer la distance en kilomètres, puis convertir en mètres et arrondir
        distance_km = geodesic(coord_a, coord_b).kilometers
        distance_meters = round(distance_km * 1000)
        return distance_meters
    else:
        raise ValueError("L'un des waypoints spécifiés n'a pas été trouvé dans le fichier GPX.")

if __name__ == "__main__":
    # Chemin vers le fichier GPX dans le même répertoire que le script
    gpx_file_path = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'gps2.gpx')
    
    waypoint_a = 'A'  # Remplacez par le nom du premier waypoint
    waypoint_b = 'B'  # Remplacez par le nom du second waypoint

    try:
        distance = calculate_distance_between_waypoints(gpx_file_path, waypoint_a, waypoint_b)
        print(f"Distance calculée : {distance} mètres")
        
        # Enregistrer le résultat dans un fichier texte
        with open("distance.txt", "w") as file:
            file.write(f"La distance entre {waypoint_a} et {waypoint_b} est de {distance} mètres\n")
        
        # print("La distance a été calculée et enregistrée dans 'distance.txt'.")
    except ValueError as e:
        print(e)
    except Exception as ex:
        print(f"Une erreur inattendue s'est produite : {ex}")










def calculate_file_hash(filepath):
    """Calcule le hash SHA-256 d'un fichier donné."""
    hasher = hashlib.sha256()
    with open(filepath, 'rb') as f:
        buf = f.read()
        hasher.update(buf)
    return hasher.hexdigest()

# Définir les répertoires de base
base_dir = os.path.dirname(os.path.abspath(__file__))
nombres_dir = os.path.join(base_dir, 'nombres')
lettres_dir = os.path.join(base_dir, 'lettres')

# Obtenir les listes de fichiers
nombres_files = [f for f in os.listdir(nombres_dir) if f.endswith('.jpg')]
lettres_files = [f for f in os.listdir(lettres_dir) if f.endswith('.jpg')]

# Calculer les hachages pour les fichiers des deux répertoires
nombres_hashes = {f: calculate_file_hash(os.path.join(nombres_dir, f)) for f in nombres_files}
lettres_hashes = {f: calculate_file_hash(os.path.join(lettres_dir, f)) for f in lettres_files}

# Créer des listes pour les correspondances
nombre_to_lettre = []
lettre_to_nombre = []

# Équivalences nombre -> lettre
for nombre_file, nombre_hash in nombres_hashes.items():
    for lettre_file, lettre_hash in lettres_hashes.items():
        if nombre_hash == lettre_hash:
            nombre_to_lettre.append(f"{nombre_file.split('.')[0]} {lettre_file.split('.')[0]}")

# Équivalences lettre -> nombre
for lettre_file, lettre_hash in lettres_hashes.items():
    for nombre_file, nombre_hash in nombres_hashes.items():
        if lettre_hash == nombre_hash:
            lettre_to_nombre.append(f"{lettre_file.split('.')[0]} {nombre_file.split('.')[0]}")

# Trier les listes par ordre alphabétique
nombre_to_lettre.sort()
lettre_to_nombre.sort()

# Créer le fichier solution.txt avec les sections séparées
with open(os.path.join(base_dir, 'solution.txt'), 'w') as solution_file:
    # Écrire les équivalences nombre -> lettre
    for entry in nombre_to_lettre:
        solution_file.write(f"{entry}\n")
    
    # Deux lignes vides pour séparer les sections
    solution_file.write("\n\n")
    
    # Écrire les équivalences lettre -> nombre
    for entry in lettre_to_nombre:
        solution_file.write(f"{entry}\n")

# print("Les équivalences ont été établies dans le fichier 'solution.txt', triées par ordre alphabétique.")

# Remplace '.jpg' par rien dans 'solution.txt'
with open('solution.txt', 'r') as file:
    content = file.read()

content = content.replace('.jpg', '')

with open('solution.txt', 'w') as file:
    file.write(content)

# Filtrer les lignes commençant par une lettre et écrire dans 'h5p.txt'
with open('solution.txt', 'r') as file:
    lines = file.readlines()

filtered_lines = [line for line in lines if re.match(r'^[a-zA-Z]', line)]

with open('h5p.txt', 'w') as file:
    file.writelines(filtered_lines)

# Mélanger les lignes de 'h5p.txt'
with open('h5p.txt', 'r') as file:
    lines = file.readlines()

random.shuffle(lines)

with open('h5p.txt', 'w') as file:
    file.writelines(lines)

# Encadrer chaque ligne par des astérisques dans 'h5p.txt'
with open('h5p.txt', 'r') as file:
    lines = file.readlines()

lines = [re.sub(r'([a-zA-Z])', r'*\1*', line) for line in lines]

with open('h5p.txt', 'w') as file:
    file.writelines(lines)

# Créer 'probleme.txt' avec le texte de présentation
header = (
    "Pour jouer, vous pouvez vous aider du plan ( s'il en a un de proposé )\n"
    "ou vous pouvez aussi utiliser votre application de géolocalisation compatible avec les fichiers kml ou gpx proposés,\n"
    "\n"
    "Il s'agit d'associer chaque lettre du plan ou visible sur votre application de géolocalisation à un numéro de photo.\n"
    "Toutes les photos numérotées sont visibles dans le document photo joint.\n"
    "Remplacez chaque double point d'interrogation par le bon numéro.\n"
    "\n"
)

# Liste temporaire pour stocker les correspondances
filename_mappings = []

# Parcourir tous les fichiers dans le répertoire 'lettres'
for file in os.listdir('lettres'):
    if file.endswith('.jpg'):
        filename = os.path.splitext(file)[0]
        filename_mappings.append(f"{filename} --> ??\n")

# Écrire le contenu dans 'probleme.txt'
with open('probleme.txt', 'w') as file:
    file.write(header)
    file.writelines(filename_mappings)
    
 # Lire le contenu du fichier h5p.txt et concaténer les lignes avec \\n sauf pour la dernière ligne
with open('h5p.txt', 'r') as file:
    lines = file.readlines()

# Concaténer les lignes avec \\n entre chaque ligne
concatenated_string = "\\n".join(line.strip() for line in lines)

# Remplacer chaque antislash (\) par deux antislashes (\\) pour l'échappement
modified_content = concatenated_string.replace('\\', '\\\\')

# Ajouter un seul backslash à la fin du contenu, sauf si la chaîne se termine déjà par un antislash
if modified_content and not modified_content.endswith('\\'):
    modified_content += '\\'

# Écrire le résultat modifié dans resultat_modifie.txt
with open('resultat_modifie.txt', 'w') as file:
    file.write(modified_content)

# Ajouter un backslash à la fin de la dernière ligne de resultat_modifie.txt si nécessaire
with open('resultat_modifie.txt', 'r') as file:
    lines = file.readlines()

if lines and not lines[-1].endswith('\\'):
    lines[-1] = lines[-1].rstrip() + '\\'

with open('chaine_lumi.txt', 'w') as file:
    file.writelines(lines)

# Ajouter un backslash à la fin de la dernière ligne de chaine_lumi.txt si nécessaire
with open('chaine_lumi.txt', 'r') as file:
    lines = file.readlines()

if lines and not lines[-1].endswith('\\'):
    lines[-1] = lines[-1].rstrip() + '\\'

with open('chaine_lumi2.txt', 'w') as file:
    file.writelines(lines)

# Remplacer "n\\" par "n" dans chaine_lumi2.txt pour éviter des séquences non voulues
with open('chaine_lumi2.txt', 'r') as file:
    content = file.read()

content = content.replace('n\\', 'n')

with open('chaine_lumi3.txt', 'w') as file:
    file.write(content)

# Récupérer le contenu de chaine_lumi3.txt
with open('chaine_lumi3.txt', 'r') as file:
    contenu_chaine = file.read()

# Lire le contenu de chaine_lumi3.txt
with open('chaine_lumi3.txt', 'r') as file:
    contenu_chaine = file.read()

# Ouvrir le fichier lumi_modifie.html en mode lecture
with open('extras/lumi.html', 'r') as file:
    lines = file.readlines()

# Trouver la première occurrence de la chaîne "textField" dans le fichier
ligne = 7
sub_string = 'textField'
if len(lines) >= ligne:
    index = lines[ligne - 1].find(sub_string)
    if index != -1:
        # Insérer le contenu 4 caractères après la fin de la première occurrence de "textField"
        insertion_index = index + len(sub_string) + 5
        lines[ligne - 1] = lines[ligne - 1][:insertion_index] + contenu_chaine + lines[ligne - 1][insertion_index:]

# Écrire le contenu modifié dans un fichier temporaire
with open('lumi_modifie_temp.html', 'w') as file:
    file.writelines(lines)

# Renommer le fichier temporaire avec les modifications
os.rename('lumi_modifie_temp.html', 'solution.html')

# Supprimer les fichiers temporaires
os.remove('chaine_lumi3.txt')
os.remove('chaine_lumi2.txt')
os.remove('resultat_modifie.txt')
os.remove('chaine_lumi.txt')
# os.remove('lat_long.csv')
os.remove('h5p.txt')
source_file = 'kml2.kml'
destination_dir = 'extras'

# Vérifiez si le répertoire de destination existe, sinon créez-le
if not os.path.exists(destination_dir):
    os.makedirs(destination_dir)

# Définir le chemin complet de destination
destination_file = os.path.join(destination_dir, 'kml2.kml')

# Copier le fichier
shutil.copy(source_file, destination_file)
#source_file1 = 'extras/custom_icon.png'
shutil.copy('extras/custom_icon.png', 'custom_icon.png')
shutil.copy('extras/DejaVuSans.ttf' , 'DejaVuSans.ttf' )
shutil.copy ('extras/choix_utilisateur.txt' , 'choix_utilisateur.txt')
# Appeler le script choi5.py
exec(open("extras/carto1.py").read())

os.remove('choix_utilisateur.txt')
os.remove('custom_icon.png')
# os.remove('geckodriver.log')
#os.remove('temp_map.html')

# Chemins des fichiers
image_path = 'cadastre.png'
image_path1 = 'terrain.png'
text_file_path = 'distance.txt'

try:
    # Vérifier si le fichier image existe
    if os.path.exists(image_path):
        # Charger l'image
        image = Image.open(image_path)
        draw = ImageDraw.Draw(image)

        # Charger le texte depuis le fichier
        with open(text_file_path, 'r') as file:
            text = file.readline().strip()

        # Définir la police et la taille
        try:
            font = ImageFont.truetype("extras/DejaVuSans-Bold.ttf", 24)  # Remplacez par le chemin de la police si nécessaire
        except IOError:
            font = ImageFont.load_default()

        # Obtenir la taille du texte
        text_bbox = draw.textbbox((0, 0), text, font=font)
        text_width = text_bbox[2] - text_bbox[0]
        text_height = text_bbox[3] - text_bbox[1]

        # Définir les positions
        image_width, image_height = image.size
        x =  20
        y = image_height - text_height - 15

        # Dessiner le texte sur l'image
        draw.text((x, y), text, font=font, fill="blue")

        # Sauvegarder l'image modifiée
        image.save('cadastre_with_text.png')

        #print("Texte ajouté et image sauvegardée sous 'cadastre_with_text.png'")
        os.remove ('cadastre.png')
        os.rename ('cadastre_with_text.png', 'cadastre.png')
    

except Exception as e:
    print(f"Une erreur est survenue : {e}")

try:
    # Vérifier si le fichier image existe
    if os.path.exists(image_path1):
        # Charger l'image
        image = Image.open(image_path1)
        draw = ImageDraw.Draw(image)

        # Charger le texte depuis le fichier
        with open(text_file_path, 'r') as file:
            text = file.readline().strip()

        # Définir la police et la taille
        try:
            font = ImageFont.truetype("extras/DejaVuSans-Bold.ttf", 24)  # Remplacez par le chemin de la police si nécessaire
        except IOError:
            font = ImageFont.load_default()

        # Obtenir la taille du texte
        text_bbox = draw.textbbox((0, 0), text, font=font)
        text_width = text_bbox[2] - text_bbox[0]
        text_height = text_bbox[3] - text_bbox[1]

        # Définir les positions
        image_width, image_height = image.size
        x =  20
        y = image_height - text_height - 15

        # Dessiner le texte sur l'image
        draw.text((x, y), text, font=font, fill="purple")

        # Sauvegarder l'image modifiée
        image.save('terrain_text.png')

        # print("Texte ajouté et image sauvegardée sous 'terrain_text.png'")
        os.remove ('terrain.png')
        os.rename ('terrain_text.png', 'terrain.png')
    
except Exception as e:
    print(f"Une erreur est survenue : {e}")




os.remove('DejaVuSans.ttf')
# Chemin du répertoire "output"
output_directory = os.path.join(script_directory, "output")

# Parcourir les fichiers dans le répertoire "output"
for file_name in os.listdir(output_directory):
    if file_name.startswith("photos"):
        # Chemin complet du fichier à déplacer
        file_path = os.path.join(output_directory, file_name)
        # Déplacer le fichier vers le répertoire parent
        shutil.move(file_path, script_directory)

def is_valid_directory_name(name):
    return bool(re.match(r'^[^<>:"/\\|?*]+$', name))

def create_subdirectory():
    current_dir = os.getcwd()
    
    while True:
        subdir_name = simpledialog.askstring("Nom du sous-répertoire", "Entrez le nom du nouveau sous-répertoire:")
        
        if subdir_name:
            if not is_valid_directory_name(subdir_name):
                messagebox.showerror("Erreur", "Le nom du sous-répertoire contient des caractères invalides.")
                continue

            new_subdir_path = os.path.join(current_dir, subdir_name)
            
            if os.path.exists(new_subdir_path):
                response = messagebox.askyesno("Sous-répertoire existe", 
                                                 f"Le sous-répertoire '{subdir_name}' existe déjà. Voulez-vous proposer un autre nom ?")
                if not response:  # Si l'utilisateur ne veut pas proposer un autre nom, quitter
                    break
            else:
                os.makedirs(new_subdir_path)
                messagebox.showinfo("Succès", f"Le sous-répertoire '{subdir_name}' a été créé avec succès.")

                # Déplacer et renommer les fichiers
                for item in os.listdir(current_dir):
                    item_path = os.path.join(current_dir, item)

                    # Vérifier s'il s'agit d'un fichier, qu'il n'est pas un .py, et qu'il n'est pas 'distance.txt'
                    if os.path.isfile(item_path) and not item.endswith('.py') and item not in ['distance.txt', 'geckodriver.log', 'licence.odt']:
                        new_item_name = f"{subdir_name}_{item}"
                        new_item_path = os.path.join(new_subdir_path, new_item_name)
                        shutil.move(item_path, new_item_path)

                messagebox.showinfo("Information", "Tous les fichiers (exceptés les fichiers .py et distance.txt) ont été déplacés et renommés.")
                break  # Sortie de la boucle après la création du sous-répertoire

root = tk.Tk()
root.withdraw()

create_subdirectory()

fichier1 = "temp_map.html"

# Vérifie si le fichier existe et le supprime
if os.path.exists(fichier1):
    os.remove(fichier1)
    
    
fichier2 = "geckodriver.log"
# Vérifie si le fichier existe et le supprime
if os.path.exists(fichier2):
    os.remove(fichier2)
    





root.destroy()  # Détruire la fenêtre principale après exécution de la fonction





def supprimer_fichiers():
    # Extensions des fichiers à supprimer dans le répertoire actif
    extensions_a_supprimer = ['*.jpg', '*.txt', '*.kml', '*.htm', '*.html', '*.png', '*.gpx']

    # Suppression des fichiers dans le répertoire actif
    for ext in extensions_a_supprimer:
        for fichier in glob.glob(ext):
            os.remove(fichier)
           

    # Suppression des fichiers jpg dans le sous-répertoire lettres
    sous_repertoire_lettres = 'lettres/*.jpg'
    for fichier in glob.glob(sous_repertoire_lettres):
        os.remove(fichier)
        
        
         # Suppression des fichiers jpg dans le sous-répertoire output
    sous_repertoire_output = 'output/*.jpg'
    for fichier in glob.glob(sous_repertoire_output):
        os.remove(fichier)
       
        
        # Suppression des fichiers kml dans le sous-répertoire extras
    sous_repertoire_extras = 'extras/*.kml'
    for fichier in glob.glob(sous_repertoire_extras):
        os.remove(fichier)
              
       

        # Suppression des fichiers jpg dans le sous-répertoire nombres, sauf les fichiers png
    sous_repertoire_nombres = 'nombres/*.jpg'
    for fichier in glob.glob(sous_repertoire_nombres):
        os.remove(fichier)
       

    # Ne pas supprimer les fichiers png dans le sous-répertoire nombres
    # print('Les fichiers .png dans le sous-répertoire "nombres" n\'ont pas été touchés.')

    # Ne pas supprimer les fichiers html dans le sous-répertoire extras
    # print('Les fichiers .html dans le sous-répertoire "extras" n\'ont pas été touchés.')

if __name__ == '__main__':
    supprimer_fichiers()

if os.path.exists("lettres"):
    # Supprimer le répertoire "lettres" s'il existe
    os.rmdir("lettres")
    

 # Suppression des fichiers kml dans le sous-répertoire extras
   # sous_repertoire_extras = 'extras/*.kml'
   # for fichier in glob.glob(sous_repertoire_extras):
    #    os.remove(fichier)
      #  print(f'Supprimé : {fichier}')


if os.path.exists("output"):
    # Supprimer le répertoire "output" s'il existe
    os.rmdir("output")
