#!/usr/bin/env python3
# -*- coding: utf-8 -*-
import os
import shutil

'''
 * Carto_photos  - annulation.py
 * Copyright (C) [2024] [BOTREL]
 *
 * Ce programme est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier selon les termes de la licence GNU General Public License
 * telle que publiée par la Free Software Foundation, soit la version 3
 * de la licence, soit (à votre choix) toute version ultérieure.
 *
 * Ce programme est distribué dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de
 * QUALITÉ MARCHANDE ou d'ADÉQUATION À UN USAGE PARTICULIER. Consultez la
 * GNU General Public License pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la GNU General Public License
 * avec ce programme. Si ce n'est pas le cas, consultez <https://www.gnu.org/licenses/>.
 '''

def delete_directory(directory):
    """
    Supprime un répertoire et tout son contenu.

    Args:
        directory (str): Le chemin du répertoire à supprimer.
    """
    if os.path.exists(directory):
        try:
            shutil.rmtree(directory)
            print(f"Répertoire supprimé: {directory}")
        except Exception as e:
            print(f"Erreur lors de la suppression de {directory}: {e}")
    else:
        print(f"Le répertoire {directory} n'existe pas.")

def delete_files_with_extension(directory, extension):
    """
    Supprime tous les fichiers d'une certaine extension dans un répertoire.

    Args:
        directory (str): Le chemin du répertoire où rechercher les fichiers.
        extension (str): L'extension des fichiers à supprimer (ex: '.jpg').
    """
    for root, dirs, files in os.walk(directory):
        for file in files:
            if file.endswith(extension):
                file_path = os.path.join(root, file)
                try:
                    os.remove(file_path)
                    print(f"Fichier supprimé: {file_path}")
                except Exception as e:
                    print(f"Erreur lors de la suppression de {file_path}: {e}")

def delete_files_in_current_directory(extensions):
    """
    Supprime tous les fichiers avec les extensions spécifiées dans le répertoire courant.

    Args:
        extensions (list): Liste des extensions des fichiers à supprimer (ex: ['.html', '.txt']).
    """
    current_directory = os.path.dirname(os.path.abspath(__file__))
    for file in os.listdir(current_directory):
        if any(file.endswith(ext) for ext in extensions):
            file_path = os.path.join(current_directory, file)
            try:
                os.remove(file_path)
                print(f"Fichier supprimé: {file_path}")
            except Exception as e:
                print(f"Erreur lors de la suppression de {file_path}: {e}")

if __name__ == "__main__":
    # Obtenir le chemin du dossier où se trouve le script
    current_directory = os.path.dirname(os.path.abspath(__file__))

    # Supprimer les répertoires 'lettres' et 'output'
    delete_directory(os.path.join(current_directory, 'lettres'))
    delete_directory(os.path.join(current_directory, 'output'))

    # Supprimer tous les fichiers .jpg dans le sous-répertoire 'nombres'
    delete_files_with_extension(os.path.join(current_directory, 'nombres'), '.jpg')

    # Supprimer les fichiers avec les extensions spécifiées dans le répertoire courant
    extensions_to_delete = ['.html', '.txt', '.kml', '.csv', '.gpx', '.png', '.ttf']
    delete_files_in_current_directory(extensions_to_delete)
