#!/usr/bin/env python3
# -*- coding: utf-8 -*-
'''
 * Carto_photos  - desinstall_modules.py
 * Copyright (C) [2024] [BOTREL]
 *
 * Ce programme est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier selon les termes de la licence GNU General Public License
 * telle que publiée par la Free Software Foundation, soit la version 3
 * de la licence, soit (à votre choix) toute version ultérieure.
 *
 * Ce programme est distribué dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de
 * QUALITÉ MARCHANDE ou d'ADÉQUATION À UN USAGE PARTICULIER. Consultez la
 * GNU General Public License pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la GNU General Public License
 * avec ce programme. Si ce n'est pas le cas, consultez <https://www.gnu.org/licenses/>.
 '''

import subprocess
import sys
import pkg_resources
import os

def check_distro():
    """Check the operating system and distribution."""
    if os.name == 'nt':
        # Windows OS
        print("Système détecté: Windows. Continuation de l'exécution du script.")
    elif os.name == 'posix':
        # Linux or other UNIX-like OS
        try:
            with open("/etc/os-release", "r") as f:
                os_info = f.read().lower()
                if "puppy" in os_info:
                    print("Vous êtes sur Puppy Linux. Ce script ne peut pas être exécuté sur cette distribution. Veuillez quitter le programme.")
                    sys.exit(1)
                else:
                    print("Système Linux détecté, mais ce n'est pas Puppy Linux. Continuation de l'exécution du script.")
        except FileNotFoundError:
            print("Impossible de déterminer la distribution Linux. Le fichier /etc/os-release est introuvable.")
            sys.exit(1)
    else:
        print("Système d'exploitation non supporté.")
        sys.exit(1)

def uninstall(package):
    """Uninstall a package using pip."""
    subprocess.check_call([sys.executable, "-m", "pip", "uninstall", "-y", package])

def is_installed(package_name):
    """Check if a package is installed."""
    installed_packages = {pkg.key for pkg in pkg_resources.working_set}
    return package_name.lower() in installed_packages

def main():
	# Vérifier le système d'exploitation et la distribution
    check_distro()
	
    # Liste des paquets à désinstaller
    packages = [
        "setuptools",    # setuptools
        "Pillow",        # Pillow
        "lxml",          # lxml
        #"tk",            # tkinter (part of standard library, but might require tk if using a custom Python installation)
        "selenium",      # selenium
        "geopandas",     # geopandas
        "folium",        # folium
        "fastkml",       # fastkml
        "piexif",        # piexif
        "geopy",         # geopy
        "wand",          # wand
        "distro",        # identifieur de systeme d'exploitation
        "pillow-heif",   # pillow-heif
    ]
    
    # Désinstallation des paquets
    for package in packages:
        if is_installed(package):
            print(f"{package} est installé. Désinstallation en cours...")
            uninstall(package)
        else:
            print(f"{package} n'est pas installé. Aucune action nécessaire.")
    
    print("Désinstallation terminée.")

if __name__ == "__main__":
    main()
