#!/usr/bin/env python3
# -*- coding: utf-8 -*-
'''
 * Carto_photos  - choix_fonds_de_carte.py
 * Copyright (C) [2024] [BOTREL]
 *
 * Ce programme est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier selon les termes de la licence GNU General Public License
 * telle que publiée par la Free Software Foundation, soit la version 3
 * de la licence, soit (à votre choix) toute version ultérieure.
 *
 * Ce programme est distribué dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de
 * QUALITÉ MARCHANDE ou d'ADÉQUATION À UN USAGE PARTICULIER. Consultez la
 * GNU General Public License pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la GNU General Public License
 * avec ce programme. Si ce n'est pas le cas, consultez <https://www.gnu.org/licenses/>.
 '''

import sys
import os
import tkinter as tk
from tkinter import simpledialog, messagebox



# Chemin du fichier pour stocker le choix de l'utilisateur
fichier_choix = 'choix_utilisateur.txt'

# Fonctions pour chaque partie
def partie_1():
    openstreetmap = "open street map terrain mémorisé"
    print(openstreetmap)  # Suppression du messagebox

def partie_2():
    google = "google satellite mémorisé"
    print(google)  # Suppression du messagebox

def partie_3():
    cadastre = "cadastre mémorisé"
    print(cadastre)  # Suppression du messagebox

# Fonction pour capturer et mémoriser le choix
def executer_choix():
    choix = []
    if var1.get():
        choix.append('1')
        partie_1()
    if var2.get():
        choix.append('2')
        partie_2()
    if var3.get():
        choix.append('3')
        partie_3()

    # Si rien n'est coché, exécuter la partie 1 par défaut
    if not choix:
        partie_1()
        choix.append('1')

    choix_utilisateur = ''.join(choix)
    if choix_utilisateur:
        ecrire_choix(fichier_choix, choix_utilisateur)

    # Fermer la fenêtre après l'exécution
    root.destroy()

# Lire le dernier choix de l'utilisateur depuis le fichier
def lire_dernier_choix(fichier):
    if os.path.exists(fichier):
        with open(fichier, 'r') as f:
            return f.read().strip()
    return None

# Écrire le choix de l'utilisateur dans le fichier
def ecrire_choix(fichier, choix):
    with open(fichier, 'w') as f:
        f.write(choix)

# Création de l'interface utilisateur avec Tkinter
root = tk.Tk()
root.title("Choix des tuiles utilisées (plusieurs choix sont possibles)")

# Configuration pour afficher en plein écran
root.attributes('-fullscreen', True)

# Affichage du titre dans la fenêtre en plein écran
label_title = tk.Label(root, text="Choix des tuiles utilisées (plusieurs choix sont possibles)", font=("Arial", 24))
label_title.pack(pady=20)

# Variables pour les cases à cocher
var1 = tk.IntVar()
var2 = tk.IntVar()
var3 = tk.IntVar()

# Dernier choix mémorisé
dernier_choix = lire_dernier_choix(fichier_choix)

# Cases à cocher pour chaque partie
check1 = tk.Checkbutton(root, text="Open street map", variable=var1, font=("Arial", 18))
check2 = tk.Checkbutton(root, text="Google satellite", variable=var2, font=("Arial", 18))
check3 = tk.Checkbutton(root, text="Cadastre.gouv.fr", variable=var3, font=("Arial", 18))

# Positionnement des cases à cocher
check1.pack(pady=10)
check2.pack(pady=10)
check3.pack(pady=10)

# Récupération du dernier choix et pré-cochage
if dernier_choix:
    if '1' in dernier_choix:
        var1.set(1)
    if '2' in dernier_choix:
        var2.set(1)
    if '3' in dernier_choix:
        var3.set(1)

# Bouton pour exécuter les choix
btn = tk.Button(root, text="Exécuter", command=executer_choix, font=("Arial", 18))
btn.pack(pady=50)

# Boucle principale Tkinter
root.mainloop()
