#!/usr/bin/env python3
# -*- coding: utf-8 -*-

'''
 * Carto_photos  - install_modules_puppy.py
 * Copyright (C) [2024] [BOTREL]
 *
 * Ce programme est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier selon les termes de la licence GNU General Public License
 * telle que publiée par la Free Software Foundation, soit la version 3
 * de la licence, soit (à votre choix) toute version ultérieure.
 *
 * Ce programme est distribué dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de
 * QUALITÉ MARCHANDE ou d'ADÉQUATION À UN USAGE PARTICULIER. Consultez la
 * GNU General Public License pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la GNU General Public License
 * avec ce programme. Si ce n'est pas le cas, consultez <https://www.gnu.org/licenses/>.
 '''

import subprocess
import sys
import os
import time

def run_command(command):
    """Exécute une commande shell et affiche la sortie en temps réel."""
    process = subprocess.Popen(command, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)
    for line in process.stdout:
        print(line, end='')
    process.stdout.close()
    process.wait()

def install_packages_dpkg(packages):
    """Installe des paquets sur Puppy Linux via dpkg."""
    for package in packages:
        run_command(f"apt-get install -y {package}")

def check_distro():
    """Vérifie si le système est Puppy Linux et arrête le script si ce n'est pas le cas."""
    try:
        with open("/etc/os-release", "r") as f:
            os_info = f.read().lower()
            if "puppy" in os_info:
                print("Vous êtes sur Puppy Linux.")
            else:
                print("Ce script ne peut être exécuté que sur Puppy Linux.")
                sys.exit(1)
    except FileNotFoundError:
        print("Impossible de déterminer la distribution Linux. Le fichier /etc/os-release est introuvable.")
        sys.exit(1)

def main():
    

    # Installation des modules Python spécifiés
    install_packages_dpkg(python_modules)
    print("Installation terminée.")

    

if __name__ == "__main__":
    # Liste des modules Python à installer
    python_modules = [
        "python3-pillow",
        "python3-lxml",
        "python3-selenium",
        "python3-geopandas",
        "python3-folium",
        "python3-fastkml",
        "python3-piexif",
        "python3-geopy",
        "python3-wand",
        "python3-distro",
        "python3-tk",
        "python3-fiona"
        # Ajoutez d'autres modules ici si nécessaire
    ]

    main()
