#!/usr/bin/env python3
# -*- coding: utf-8 -*-
'''
 * Carto_photos  - correcteur_position_photos.py
 * Copyright (C) [2024] [BOTREL]
 *
 * Ce programme est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier selon les termes de la licence GNU General Public License
 * telle que publiée par la Free Software Foundation, soit la version 3
 * de la licence, soit (à votre choix) toute version ultérieure.
 *
 * Ce programme est distribué dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de
 * QUALITÉ MARCHANDE ou d'ADÉQUATION À UN USAGE PARTICULIER. Consultez la
 * GNU General Public License pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la GNU General Public License
 * avec ce programme. Si ce n'est pas le cas, consultez <https://www.gnu.org/licenses/>.
 '''

import webbrowser
import os
import time

# Set environment variable in Python
os.environ['MESA_GLTHREAD'] = 'false'

'''principe
Commencez par ouvrir votre navigateur internet puis allez dans le répertoire extras 
Le fichier à utiliser s'appelle correcteur_position_photos.py
On le copie et on le colle dans le repertoire créé où il y a des problèmes de position
On le lance  soit avec geany soit avec la commande python3 correcteur_position_photos.py 
Une fenêtre du navigateur  avec le plan s'ouvre 
on entre la distance entre les points A et B dans la zone prévue
On bouge les croix noires en centrant une sur la lettre A et l'autre sur la lettre B
On  regarde la fenêtre du script pous savoir si la lettre proposée est à modifier 
	Si oui on repasse sur le navigateur
	on met la croix verte sur le bas de la bulle de la lettre à modifier et la croix rouge à l'endroit où devrait être le bas de la bulle 
	A côté de la zone où vous avez entré la distance, il y a une distance et un azimut (direction) qui s'affichent automatiquement sous le plan
	Ce sont ces informations qu'il faut entrer dans la fenêtre du script
		quand on   met  10  entrée puis  90  entrée pour la lettre B cela modifiera les données exif de la photo  liée à B
		et cela la placera à 10 mètres à droite de l'endroit initial jugé erroné lors d'une prochaine  utilisation du programme
		
	Si non il n'y a rien à modifier  donc on met 0 entrée 0 entrée	
Après on modifie chaque lettre du plan dans l'ordre proposé par le script  avec une une distance et une direction qu'on peut trouver
grâce au navigateur en bougeant la croix verte sur le bas de la lettre bulle à modifier et la croix rouge à l'endroit où devrait être le bas de cette bulle 
il est obligatoire de repeter l'opération pour toutes les lettres :
	
Quand on a fait toutes les lettres on peut fermer le script en appuyant sur entrée et fermer aussi le navigateur
On copie toutes les photos qui ont maintenant des données exif justes  et on les colle dans carto photos et on lance le script pour avoir la version finale
'''

import csv
import math
from PIL import Image
import piexif
import time
import shutil
import glob



# Chemin du répertoire où se trouve le programme Python et le fichier à copier
repertoire_actuel = os.path.dirname(__file__)

# Rechercher le fichier qui termine par "terrain.png" dans le même répertoire que le programme
fichiers_terrain = glob.glob(os.path.join(repertoire_actuel, '*terrain.png'))

# S'assurer qu'on a trouvé au moins un fichier correspondant
if fichiers_terrain:
    chemin_source = fichiers_terrain[0]  # Prendre le premier fichier trouvé
    print(f"Fichier trouvé : {chemin_source}")
    
    # Chemin destination vers plan.png dans le répertoire cousin "extras"
    chemin_destination = os.path.join(repertoire_actuel, '..', 'extras', 'plan.png')

    # Copier et renommer le fichier
    shutil.copyfile(chemin_source, chemin_destination)

    print(f"Fichier copié et renommé de {chemin_source} vers {chemin_destination}")
else:
    print("Aucun fichier se terminant par 'terrain.png' n'a été trouvé dans le répertoire actuel.")
# Chemin vers le fichier HTML (on remonte d'un niveau et on entre dans 'pages_html')
chemin_html = os.path.join(os.path.dirname(__file__), '..', 'extras', 'plan.html')

#Ouvrir la page HTML dans le navigateur par défaut
webbrowser.open_new_tab(f'file://{os.path.abspath(chemin_html)}')
time.sleep(5)
url = f'file://{os.path.abspath(chemin_html)}'


for i in range(1):
    #print(f"Tâche {i+1} en cours...")
    time.sleep(1)  # Pause d'une seconde pour simuler une tâche







# Fonction pour calculer la nouvelle latitude et longitude
def calculer_nouvelles_coordonnees(lat, lon, distance, angle):
    # Conversion en radians
    lat_radians = math.radians(lat)
    lon_radians = math.radians(lon)
    angle_radians = math.radians(angle)
    
    # Rayon de la Terre en mètres
    rayon_terre = 6378137
    
    # Calcul de la nouvelle latitude
    nouvelle_latitude = lat + (distance * math.cos(angle_radians)) / rayon_terre * (180 / math.pi)
    
    # Calcul de la nouvelle longitude
    nouvelle_longitude = lon + (distance * math.sin(angle_radians)) / (rayon_terre * math.cos(lat_radians)) * (180 / math.pi)
    
    return nouvelle_latitude, nouvelle_longitude

# Fonction pour convertir des degrés décimaux en format EXIF (degrés, minutes, secondes)
def convertir_en_degrees_minutes_secondes(coord):
    degrees = int(coord)
    minutes = int((coord - degrees) * 60)
    seconds = (coord - degrees - minutes / 60) * 3600
    return degrees, minutes, seconds

# Fonction pour convertir en format EXIF
def convertir_exif(coord, ref):
    d, m, s = convertir_en_degrees_minutes_secondes(abs(coord))
    return ((d, 1), (m, 1), (int(s * 100), 100)), ref

# Fonction pour mettre à jour les coordonnées EXIF dans un fichier JPG
def mettre_a_jour_exif(image_path, latitude, longitude):
    image = Image.open(image_path)
    exif_dict = piexif.load(image.info['exif'])

    # Conversion des coordonnées en format EXIF
    lat_exif, lat_ref = convertir_exif(latitude, 'N' if latitude >= 0 else 'S')
    lon_exif, lon_ref = convertir_exif(longitude, 'E' if longitude >= 0 else 'W')

    # Mise à jour des informations EXIF
    exif_dict['GPS'][piexif.GPSIFD.GPSLatitude] = lat_exif
    exif_dict['GPS'][piexif.GPSIFD.GPSLatitudeRef] = lat_ref.encode()
    exif_dict['GPS'][piexif.GPSIFD.GPSLongitude] = lon_exif
    exif_dict['GPS'][piexif.GPSIFD.GPSLongitudeRef] = lon_ref.encode()

    # Sauvegarde de l'image avec les données EXIF modifiées
    exif_bytes = piexif.dump(exif_dict)
    image.save(image_path, 'jpeg', exif=exif_bytes)

# Trouver automatiquement le fichier CSV dans le répertoire courant
fichier_csv_nom = None
for fichier in os.listdir('.'):
    if fichier.endswith('.csv'):
        fichier_csv_nom = fichier
        break

if not fichier_csv_nom:
    print("Aucun fichier CSV trouvé dans le répertoire.")
    exit()

print(f"Fichier CSV détecté : {fichier_csv_nom}")

# Lecture du fichier CSV d'origine
with open(fichier_csv_nom, mode='r') as fichier_csv:
    reader = csv.reader(fichier_csv)
    lignes = list(reader)  # Lecture de toutes les lignes du fichier

# Ajout des colonnes Distance et Direction
for ligne in lignes:
    ligne.append('')  # Colonne pour la distance
    ligne.append('')  # Colonne pour la direction

# Affichage du tableau pour modification
print("Modifier les valeurs des colonnes 5 (Distance en mètres) et 6 (Direction en degrés) :")
for i, ligne in enumerate(lignes):
    print(f"Ligne {i+1}: {ligne}")
    distance = input("Distance (mètres) : ")
    direction = input("Direction (degrés) : ")
    lignes[i][4] = float(distance)
    lignes[i][5] = float(direction)

# Création du nouveau fichier CSV avec les coordonnées mises à jour
with open('nouveaux_waypoints.csv', mode='w', newline='') as fichier_csv:
    writer = csv.writer(fichier_csv)
    
    for ligne in lignes:
        nom, taille, lat, lon, distance, direction = ligne
        lat, lon = float(lat), float(lon)
        distance, direction = float(distance), float(direction)
        
        # Calcul des nouvelles coordonnées
        nouvelle_latitude, nouvelle_longitude = calculer_nouvelles_coordonnees(lat, lon, distance, direction)
        
        # Écriture de la ligne corrigée dans le nouveau fichier
        writer.writerow([nom, taille, f"{nouvelle_latitude:.6f}", f"{nouvelle_longitude:.6f}"])

        # Rechercher le fichier JPG correspondant par taille et mettre à jour ses EXIF
        for image_path in os.listdir('.'):
            if image_path.endswith('.jpg') or image_path.endswith('.jpeg'):
                if os.path.getsize(image_path) == int(taille):
                    try:
                        mettre_a_jour_exif(image_path, nouvelle_latitude, nouvelle_longitude)
                        print(f"EXIF mis à jour pour {image_path}")
                    except Exception as e:
                        print(f"Erreur lors de la mise à jour des EXIF pour {image_path}: {e}")
                    break

print("Mise à jour des données EXIF terminée.")
