#!/usr/bin/env python3
# -*- coding: utf-8 -*-
'''
 * Carto_photos  - install_modules.py
 * Copyright (C) [2024] [BOTREL]
 *
 * Ce programme est un logiciel libre : vous pouvez le redistribuer et/ou
 * le modifier selon les termes de la licence GNU General Public License
 * telle que publiée par la Free Software Foundation, soit la version 3
 * de la licence, soit (à votre choix) toute version ultérieure.
 *
 * Ce programme est distribué dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de
 * QUALITÉ MARCHANDE ou d'ADÉQUATION À UN USAGE PARTICULIER. Consultez la
 * GNU General Public License pour plus de détails.
 *
 * Vous devriez avoir reçu une copie de la GNU General Public License
 * avec ce programme. Si ce n'est pas le cas, consultez <https://www.gnu.org/licenses/>.
 '''

import subprocess
import sys
import os
import time

ADMIN_PASSWORD = "tuxprof"

def run_command(command):
    """Exécute une commande shell et affiche la sortie en temps réel."""
    process = subprocess.Popen(command, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)
    for line in process.stdout:
        print(line, end='')
    process.stdout.close()
    process.wait()

def is_package_installed(package_name):
    """Vérifie si un paquet est déjà installé."""
    try:
        subprocess.check_output(['dpkg', '-s', package_name], stderr=subprocess.STDOUT)
        return True
    except subprocess.CalledProcessError:
        return False

def update_system():
    """Met à jour la liste des paquets et met à jour le système."""
    print("Mise à jour de la liste des paquets...")
    run_command("apt update")
    print("Mise à jour du système...")
    run_command("apt upgrade -y")

def install_python_modules(modules):
    """Installe une liste de modules Python via apt, si nécessaire."""
    for module in modules:
        if not is_package_installed(module):
             print(f"Installation de {module}...")
             run_command(f"sudo apt install -y {module}")
        else:
             print(f"{module} est déjà installé, pas besoin de l'installer.")

def is_package_installed(package):
    """Check if a Python package is installed by attempting to import it."""
    try:
        __import__(package)
        return True
    except ImportError:
        return False

def update_pip():
    """Update pip to the latest version, using sudo on Linux if necessary."""
    try:
        if os.name == 'posix' and 'debian' in open("/etc/os-release").read().lower():
            print("Mise à jour de pip avec sudo...")
            command = f"echo {ADMIN_PASSWORD} | sudo -S {sys.executable} -m pip install --upgrade pip"
            subprocess.check_call(command, shell=True)
        else:
            subprocess.check_call([sys.executable, "-m", "pip", "install", "--upgrade", "pip"])
        print("pip a été mis à jour avec succès.")
    except subprocess.CalledProcessError as e:
        print(f"Erreur lors de la mise à jour de pip: {e}")
        sys.exit(1)

def install_and_upgrade(package):
    """Install or upgrade a package using pip via subprocess."""
    try:
        subprocess.check_call([sys.executable, "-m", "pip", "install", "--upgrade", package])
    except subprocess.CalledProcessError as e:
        print(f"Erreur lors de l'installation de {package}: {e}")
        sys.exit(1)

def check_distro():
    """Check the operating system and distribution."""
    if os.name == 'nt':
        # Windows OS
        print("Système détecté: Windows. Continuation de l'exécution du script.")
    elif os.name == 'posix':
        # Linux or other UNIX-like OS
        try:
            with open("/etc/os-release", "r") as f:
                os_info = f.read().lower()
                if "puppy" in os_info:
                    print("Vous êtes sur Puppy Linux. Ce script ne peut pas être exécuté sur cette distribution ... veuillez quitter le programme, recharger le gestionnaire de paquets synaptic si vous ne l'avez pas dejà fait, fermer synaptic et lancer le script install_modules_puppy.py.")
                    print("Le script se terminera dans 10 secondes...")
                    time.sleep(10)
                    
    
                                    
                    
                    sys.exit(1)
                else:
                    print("Système Linux détecté, mais ce n'est pas Puppy Linux. Continuation de l'exécution du script.")
        except FileNotFoundError:
            print("Impossible de déterminer la distribution Linux. Le fichier /etc/os-release est introuvable.")
            sys.exit(1)
    else:
        print("Système d'exploitation non supporté.")
        sys.exit(1)

def main():
    # Vérifier le système d'exploitation et la distribution
    check_distro()

    # Mettre à jour pip
    print("Mise à jour de pip...")
    update_pip()
    
    # Liste des paquets à installer
    packages = {
        "setuptools" : "setuptools" , # pour pouvoir utiliser fastkml
        "Pillow": "PIL",        # Pillow (PIL is the import name)
        "lxml": "lxml",         # lxml
        "selenium": "selenium", # selenium
        "geopandas": "geopandas", # geopandas
        "folium": "folium",     # folium
        "fastkml": "fastkml",   # fastkml
        "piexif": "piexif",     # piexif
        "geopy": "geopy",       # geopy
        "wand": "wand", # wand
        "distro": "distro", # indicateur systeme exploitation
        "pillow-heif": "pillow-heif", # pour transformer hei* en jpg
		"fiona" : "fiona", # pour primtux 8 avec python3.10
		"shapely" : "shapely", # pour primtux 8 avec python3.10
		"pyproj" : "pyproj" # pour primtux 8 avec python3.10
            }

    # Installation des paquets si non installés
    for package, import_name in packages.items():
        if not is_package_installed(import_name):
            print(f"Installation de {package}...")
            install_and_upgrade(package)
        else:
            print(f"{package} est déjà installé.")

    print("Installation terminée.")

    # Pause de 10 secondes avant de quitter
    print("Le script se terminera dans 10 secondes...")
    time.sleep(10)

if __name__ == "__main__":
    main()
